/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.caches;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.SpatialLayerDAO$;
import au.org.ala.biocache.caches.WebServiceLoader$;
import au.org.ala.biocache.model.FullRecord;
import au.org.ala.biocache.util.StringHelper$;
import au.org.ala.layers.intersect.SimpleShapeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.json.JSON$;

public final class SpatialLayerDAO$ {
    public static final SpatialLayerDAO$ MODULE$;
    private final Logger logger;
    private final HashMap<String, String> idNameLookup;
    private final HashMap<String, String> nameFieldLookup;
    private final HashMap<String, SimpleShapeFile> loadedShapeFiles;
    private final Object lock;
    private final LRUMap lru;
    private List<String> sdsLayerList;
    private boolean init;
    private volatile boolean bitmap$0;

    static {
        new SpatialLayerDAO$();
    }

    private boolean init$lzycompute() {
        SpatialLayerDAO$ spatialLayerDAO$ = this;
        synchronized (spatialLayerDAO$) {
            if (!this.bitmap$0) {
                if (StringUtils.isNotEmpty((String)Config$.MODULE$.layersServiceUrl()) && (Config$.MODULE$.layersServiceSampling() || Config$.MODULE$.sdsEnabled())) {
                    this.logger().info(new StringBuilder().append((Object)"Loading Layer information from .....").append((Object)Config$.MODULE$.layersServiceUrl()).toString());
                    String layersJson = WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)Config$.MODULE$.layersServiceUrl()).append((Object)"/layers").toString());
                    String fieldsJson = WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)Config$.MODULE$.layersServiceUrl()).append((Object)"/fields").toString());
                    List layers = (List)JSON$.MODULE$.parseFull(layersJson).getOrElse((Function0)new anonfun.1());
                    this.logger().info(new StringBuilder().append((Object)"Number of layers loaded .....").append((Object)BoxesRunTime.boxToInteger((int)layers.size())).toString());
                    layers.foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Option<String> apply(scala.collection.immutable.Map<String, String> layer) {
                            return SpatialLayerDAO$.MODULE$.idNameLookup().put((Object)((Object)BoxesRunTime.boxToInteger((int)((int)BoxesRunTime.unboxToDouble((Object)layer.getOrElse((Object)"id", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply() {
                                    return this.apply$mcI$sp();
                                }

                                public int apply$mcI$sp() {
                                    return -1;
                                }
                            }))))).toString(), layer.getOrElse((Object)"name", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            }));
                        }
                    });
                    List fields = (List)JSON$.MODULE$.parseFull(fieldsJson).getOrElse((Function0)new anonfun.2());
                    this.logger().info(new StringBuilder().append((Object)"Number of fields loaded .....").append((Object)BoxesRunTime.boxToInteger((int)fields.size())).toString());
                    fields.foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Option<String> apply(scala.collection.immutable.Map<String, String> field) {
                            return SpatialLayerDAO$.MODULE$.nameFieldLookup().put(field.getOrElse((Object)"spid", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "-1";
                                }
                            }), field.getOrElse((Object)"sname", (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "";
                                }
                            }));
                        }
                    });
                }
                this.logger().info(new StringBuilder().append((Object)"SDS enabled .....").append((Object)BoxesRunTime.boxToBoolean((boolean)Config$.MODULE$.sdsEnabled())).toString());
                if (Config$.MODULE$.sdsEnabled()) {
                    if (StringUtils.isNotBlank((String)Config$.MODULE$.sdsLayersUrl()) && Config$.MODULE$.sdsLayersUrl().startsWith("http")) {
                        this.logger().info("Loaded layers required by SDS.....");
                        String sdsLayerListURL = Config$.MODULE$.sdsLayersUrl();
                        this.logger().info(new StringBuilder().append((Object)"Retrieving list from ").append((Object)sdsLayerListURL).toString());
                        String sdsListJson = WebServiceLoader$.MODULE$.getWSStringContent(sdsLayerListURL);
                        this.sdsLayerList_$eq((List<String>)((List)JSON$.MODULE$.parseFull(sdsListJson).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final List<String> apply() {
                                return Nil$.MODULE$;
                            }
                        })));
                    } else {
                        File file = new File(Config$.MODULE$.sdsLayersUrl());
                        InputStream stream = file.exists() ? new FileInputStream(file) : this.getClass().getResourceAsStream(Config$.MODULE$.sdsLayersUrl());
                        String sdsListJson = JavaConversions$.MODULE$.asScalaBuffer(IOUtils.readLines((InputStream)stream, (String)"UTF-8")).mkString();
                        this.sdsLayerList_$eq((List<String>)((List)JSON$.MODULE$.parseFull(sdsListJson).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final List<String> apply() {
                                return Nil$.MODULE$;
                            }
                        })));
                    }
                    this.sdsLayerList().foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(String layerID) {
                            SpatialLayerDAO$.MODULE$.logger().info(new StringBuilder().append((Object)"Loading SDS layer.....").append((Object)layerID).toString());
                            SpatialLayerDAO$.MODULE$.au$org$ala$biocache$caches$SpatialLayerDAO$$loadLayer(layerID, true);
                        }
                    });
                } else {
                    this.logger().info("SDS disabled - skipping layer loading.....");
                }
                if (StringUtils.isNotBlank((String)Config$.MODULE$.stateProvinceLayerID())) {
                    this.au$org$ala$biocache$caches$SpatialLayerDAO$$loadLayer(Config$.MODULE$.stateProvinceLayerID(), false);
                }
                if (StringUtils.isNotBlank((String)Config$.MODULE$.terrestrialLayerID())) {
                    this.au$org$ala$biocache$caches$SpatialLayerDAO$$loadLayer(Config$.MODULE$.terrestrialLayerID(), false);
                }
                if (StringUtils.isNotBlank((String)Config$.MODULE$.marineLayerID())) {
                    this.au$org$ala$biocache$caches$SpatialLayerDAO$$loadLayer(Config$.MODULE$.marineLayerID(), false);
                }
                if (StringUtils.isNotBlank((String)Config$.MODULE$.countriesLayerID())) {
                    this.au$org$ala$biocache$caches$SpatialLayerDAO$$loadLayer(Config$.MODULE$.countriesLayerID(), false);
                }
                if (StringUtils.isNotBlank((String)Config$.MODULE$.localGovLayerID())) {
                    this.au$org$ala$biocache$caches$SpatialLayerDAO$$loadLayer(Config$.MODULE$.localGovLayerID(), false);
                }
                this.init = true;
                this.bitmap$0 = true;
            }
            return this.init;
        }
    }

    public Logger logger() {
        return this.logger;
    }

    public HashMap<String, String> idNameLookup() {
        return this.idNameLookup;
    }

    public HashMap<String, String> nameFieldLookup() {
        return this.nameFieldLookup;
    }

    public HashMap<String, SimpleShapeFile> loadedShapeFiles() {
        return this.loadedShapeFiles;
    }

    private Object lock() {
        return this.lock;
    }

    private LRUMap lru() {
        return this.lru;
    }

    public List<String> sdsLayerList() {
        return this.sdsLayerList;
    }

    public void sdsLayerList_$eq(List<String> x$1) {
        this.sdsLayerList = x$1;
    }

    public boolean init() {
        return this.bitmap$0 ? this.init : this.init$lzycompute();
    }

    public void au$org$ala$biocache$caches$SpatialLayerDAO$$loadLayer(String layerID, boolean errorIfNotAvailable) {
        String id = layerID.replaceAll("cl", "");
        File f = new File(new StringBuilder().append((Object)Config$.MODULE$.layersDirectory()).append(this.idNameLookup().getOrElse((Object)id, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "xxxxx";
            }
        })).append((Object)".shp").toString());
        this.logger().info(new StringBuilder().append((Object)"Geospatial ID...").append((Object)layerID).append((Object)" - available: ").append((Object)BoxesRunTime.boxToBoolean((boolean)f.exists())).append((Object)" - ").append((Object)f.getAbsolutePath()).append((Object)", field name: ").append(this.nameFieldLookup().getOrElse((Object)id, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "xxxxx";
            }
        })).toString());
        if (f.exists()) {
            SimpleShapeFile ssf = new SimpleShapeFile(new StringBuilder().append((Object)Config$.MODULE$.layersDirectory()).append(this.idNameLookup().getOrElse((Object)id, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "xxxxx";
                }
            })).toString(), (String)this.nameFieldLookup().getOrElse((Object)id, (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "xxxxx";
                }
            }));
            this.loadedShapeFiles().put((Object)layerID, (Object)ssf);
        } else if (errorIfNotAvailable) {
            throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Layer ", " unavailable on local filesystem. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{layerID}))).append((Object)"To disable SDS checking set sds.enabled=false in your external config file.").toString());
        }
    }

    private boolean loadLayer$default$2() {
        return false;
    }

    public Map<String, String> intersect(String decimalLongitude, String decimalLatitude) {
        Option<Object> optLong = StringHelper$.MODULE$.string2helper(decimalLongitude).toDoubleWithOption();
        Option<Object> optLat = StringHelper$.MODULE$.string2helper(decimalLatitude).toDoubleWithOption();
        return optLong.isEmpty() || optLong.isEmpty() ? (Map<String, String>)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$) : this.intersect(BoxesRunTime.unboxToDouble((Object)optLong.get()), BoxesRunTime.unboxToDouble((Object)optLat.get()));
    }

    public Map<String, String> intersect(FullRecord fr) {
        if (fr.location().decimalLongitude() == null || fr.location().decimalLatitude() == null) {
            return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        return this.intersect(new StringOps(Predef$.MODULE$.augmentString(fr.location().decimalLongitude())).toDouble(), new StringOps(Predef$.MODULE$.augmentString(fr.location().decimalLatitude())).toDouble());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public Map<String, String> intersect(double decimalLongitude, double decimalLatitude) {
        Map map;
        Object cachedObject;
        block7: {
            this.init();
            if (BoxesRunTime.boxToDouble((double)decimalLongitude) == null) return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            if (BoxesRunTime.boxToDouble((double)decimalLatitude) == null) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            }
            String key = this.getLatLongKey(decimalLongitude, decimalLatitude);
            Object object = this.lock();
            // MONITORENTER : object
            Object object2 = this.lru().get((Object)key);
            // MONITOREXIT : object
            cachedObject = object2;
            if (cachedObject != null) break block7;
            HashMap intersects = new HashMap();
            this.loadedShapeFiles().foreach((Function1)new Serializable(decimalLongitude, decimalLatitude, intersects){
                public static final long serialVersionUID = 0L;
                private final double decimalLongitude$1;
                private final double decimalLatitude$1;
                private final HashMap intersects$1;

                public final Object apply(Tuple2<String, SimpleShapeFile> x0$1) {
                    Tuple2<String, SimpleShapeFile> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String layerID = (String)tuple2._1();
                        SimpleShapeFile shp = (SimpleShapeFile)tuple2._2();
                        String intersectValue = shp.intersect(this.decimalLongitude$1, this.decimalLatitude$1);
                        BoxedUnit boxedUnit = intersectValue == null ? BoxedUnit.UNIT : this.intersects$1.put((Object)layerID, (Object)intersectValue);
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.decimalLongitude$1 = decimalLongitude$1;
                    this.decimalLatitude$1 = decimalLatitude$1;
                    this.intersects$1 = intersects$1;
                }
            });
            Object object3 = this.lock();
            // MONITORENTER : object3
            this.lru().put((Object)key, (Object)intersects);
            // MONITOREXIT : object3
            map = intersects;
            return map;
        }
        map = (Map)cachedObject;
        return map;
    }

    private String getLatLongKey(double longitude, double latitude) {
        return new StringBuilder().append((Object)((Object)BoxesRunTime.boxToDouble((double)longitude)).toString()).append((Object)"|").append((Object)((Object)BoxesRunTime.boxToDouble((double)latitude)).toString()).toString();
    }

    public void addToCache(double decimalLongitude, double decimalLatitude, Map<String, String> intersects) {
        this.lru().put((Object)this.getLatLongKey(decimalLongitude, decimalLatitude), intersects);
    }

    public int getCacheSize() {
        return this.lru().size();
    }

    private SpatialLayerDAO$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"SpatialLayerDAO");
        this.idNameLookup = new HashMap();
        this.nameFieldLookup = new HashMap();
        this.loadedShapeFiles = new HashMap();
        this.lock = new Object();
        this.lru = new LRUMap(Config$.MODULE$.spatialCacheSize());
        this.sdsLayerList = Nil$.MODULE$;
    }
}

