/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.index.IndexDAO;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.tool.FileDelete$;
import au.org.ala.biocache.tool.RecordDeletor;
import au.org.ala.biocache.tool.RecordDeletor$class;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.SFTPTools$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u001b\tQa)\u001b7f\t\u0016dW\r^3\u000b\u0005\r!\u0011\u0001\u0002;p_2T!!\u0002\u0004\u0002\u0011\tLwnY1dQ\u0016T!a\u0002\u0005\u0002\u0007\u0005d\u0017M\u0003\u0002\n\u0015\u0005\u0019qN]4\u000b\u0003-\t!!Y;\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\u0007SK\u000e|'\u000f\u001a#fY\u0016$xN\u001d\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005Aa-\u001b7f\u001d\u0006lW\r\u0005\u0002\u001c=9\u0011q\u0002H\u0005\u0003;A\ta\u0001\u0015:fI\u00164\u0017BA\u0010!\u0005\u0019\u0019FO]5oO*\u0011Q\u0004\u0005\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005I\u0001.Y:IK\u0006$WM\u001d\t\u0003\u001f\u0011J!!\n\t\u0003\u000f\t{w\u000e\\3b]\")q\u0005\u0001C\u0001Q\u00051A(\u001b8jiz\"2!\u000b\u0016,!\t)\u0002\u0001C\u0003\u001aM\u0001\u0007!\u0004C\u0004#MA\u0005\t\u0019A\u0012\t\u000f5\u0002!\u0019!C\u0001]\u0005Y1O\u001a;q!\u0006$H/\u001a:o+\u0005y\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003!i\u0017\r^2iS:<'B\u0001\u001b\u0011\u0003\u0011)H/\u001b7\n\u0005Y\n$!\u0002*fO\u0016D\bB\u0002\u001d\u0001A\u0003%q&\u0001\u0007tMR\u0004\b+\u0019;uKJt\u0007\u0005C\u0003;\u0001\u0011\u00053(\u0001\u000beK2,G/\u001a$s_6\u0004VM]:jgR,g\u000e^\u000b\u0002yA\u0011q\"P\u0005\u0003}A\u0011A!\u00168ji\")\u0001\t\u0001C!w\u0005yA-\u001a7fi\u00164%o\\7J]\u0012,\u0007\u0010C\u0003C\u0001\u0011%1)A\u0007hKR\u0014V-\\8uK\u001aKG.\u001a\u000b\u0003\t2\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u0005%|'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u001a\u0013AAR5mK\")\u0011$\u0011a\u00015!)a\n\u0001C\u0005\u001f\u0006aAm\\<oY>\fGMR5mKR\u0019A\b\u0015*\t\u000bEk\u0005\u0019\u0001#\u0002\t\u0019LG.\u001a\u0005\u0006'6\u0003\r\u0001V\u0001\u0003S:\u0004\"!R+\n\u0005Y3%aC%oaV$8\u000b\u001e:fC6<q\u0001\u0017\u0002\u0002\u0002#\u0005\u0011,\u0001\u0006GS2,G)\u001a7fi\u0016\u0004\"!\u0006.\u0007\u000f\u0005\u0011\u0011\u0011!E\u00017N\u0011!L\u0004\u0005\u0006Oi#\t!\u0018\u000b\u00023\"9qLWI\u0001\n\u0003\u0001\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001bU\t\u0019#mK\u0001d!\t!\u0017.D\u0001f\u0015\t1w-A\u0005v]\u000eDWmY6fI*\u0011\u0001\u000eE\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00016f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class FileDelete
implements RecordDeletor {
    private final String fileName;
    private final Regex sftpPattern;
    private final Logger logger;
    private final PersistenceManager pm;
    private final IndexDAO indexer;
    private final OccurrenceDAO occurrenceDAO;

    public static boolean $lessinit$greater$default$2() {
        return FileDelete$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public PersistenceManager pm() {
        return this.pm;
    }

    @Override
    public IndexDAO indexer() {
        return this.indexer;
    }

    @Override
    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    @Override
    public void au$org$ala$biocache$tool$RecordDeletor$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void au$org$ala$biocache$tool$RecordDeletor$_setter_$pm_$eq(PersistenceManager x$1) {
        this.pm = x$1;
    }

    @Override
    public void au$org$ala$biocache$tool$RecordDeletor$_setter_$indexer_$eq(IndexDAO x$1) {
        this.indexer = x$1;
    }

    @Override
    public void au$org$ala$biocache$tool$RecordDeletor$_setter_$occurrenceDAO_$eq(OccurrenceDAO x$1) {
        this.occurrenceDAO = x$1;
    }

    @Override
    public void close() {
        RecordDeletor$class.close(this);
    }

    public Regex sftpPattern() {
        return this.sftpPattern;
    }

    @Override
    public void deleteFromPersistent() {
        this.logger().info(new StringBuilder().append((Object)"Using file name: ").append((Object)this.fileName).toString());
        IntRef counter = new IntRef(0);
        FileHelper$.MODULE$.file2helper(this.getRemoteFile(this.fileName)).foreachLine((Function1<String, BoxedUnit>)new Serializable(this, counter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileDelete $outer;
            private final IntRef counter$1;

            public final void apply(String line) {
                this.$outer.logger().info(new StringBuilder().append((Object)"Deleting ID : ").append((Object)line).toString());
                if (line.contains(" ")) {
                    throw new RuntimeException(new StringBuilder().append((Object)"Found a potentially illegal id during delete from file, aborting to avoid corrupting the persistent store: ").append((Object)line).toString());
                }
                this.$outer.occurrenceDAO().delete(line, false, true);
                ++this.counter$1.elem;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$1 = counter$1;
            }
        });
        this.logger().info(new StringBuilder().append((Object)"Records deleted: ").append((Object)BoxesRunTime.boxToInteger((int)counter.elem)).toString());
    }

    @Override
    public void deleteFromIndex() {
        this.logger().info(new StringBuilder().append((Object)"deleteFromIndex - Using file name: ").append((Object)this.fileName).toString());
        IntRef counter = new IntRef(0);
        ArrayBuffer buf = new ArrayBuffer();
        String fieldName = "id";
        FileHelper$.MODULE$.file2helper(this.getRemoteFile(this.fileName)).foreachLine((Function1<String, BoxedUnit>)new Serializable(this, counter, buf, fieldName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileDelete $outer;
            private final IntRef counter$2;
            private final ArrayBuffer buf$1;
            private final String fieldName$1;

            public final void apply(String line) {
                this.buf$1.$plus$eq((Object)line);
                ++this.counter$2.elem;
                if (line.contains(" ")) {
                    throw new RuntimeException(new StringBuilder().append((Object)"Found a potentially illegal id during delete from file, aborting to avoid corrupting the index: ").append((Object)line).toString());
                }
                if (this.buf$1.size() > 999) {
                    String query = new StringBuilder().append((Object)this.fieldName$1).append((Object)":\"").append((Object)this.buf$1.mkString(new StringBuilder().append((Object)"\" OR ").append((Object)this.fieldName$1).append((Object)":\"").toString())).append((Object)"\"").toString();
                    this.$outer.indexer().removeByQuery(query, this.$outer.indexer().removeByQuery$default$2());
                    this.buf$1.clear();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.counter$2 = counter$2;
                this.buf$1 = buf$1;
                this.fieldName$1 = fieldName$1;
            }
        });
        String query = new StringBuilder().append((Object)fieldName).append((Object)":\"").append((Object)buf.mkString(new StringBuilder().append((Object)"\" OR ").append((Object)fieldName).append((Object)":\"").toString())).append((Object)"\"").toString();
        this.indexer().removeByQuery(query, this.indexer().removeByQuery$default$2());
        this.logger().info(new StringBuilder().append((Object)"Records deleted from index : ").append((Object)BoxesRunTime.boxToInteger((int)counter.elem)).toString());
        buf.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getRemoteFile(String fileName) {
        File file;
        if (fileName.startsWith("http")) {
            this.logger().info(new StringBuilder().append((Object)"downloading remote file.. ").append((Object)fileName).toString());
            URLConnection urlConnection = new URL(fileName).openConnection();
            InputStream in = urlConnection.getInputStream();
            File f = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/delete_row_key_file.csv").toString());
            this.logger().info(new StringBuilder().append((Object)"Creating file: ").append((Object)f.getAbsolutePath()).toString());
            f.createNewFile();
            this.downloadFile(f, in);
            file = f;
            return file;
        } else if (fileName.startsWith("sftp://")) {
            File file2;
            String string = fileName;
            Option option = this.sftpPattern().unapplySeq((Object)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(2) != 0) throw new MatchError((Object)string);
            String server = (String)((LinearSeqOptimized)option.get()).apply(0);
            String filepath = (String)((LinearSeqOptimized)option.get()).apply(1);
            File f = new File(new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/delete_row_key_file.csv").toString());
            SFTPTools$.MODULE$.scpFile(server, Config$.MODULE$.getProperty("uploadUser"), Config$.MODULE$.getProperty("uploadPassword"), filepath, f);
            file = file2 = f;
            return file;
        } else {
            file = new File(fileName);
        }
        return file;
    }

    private void downloadFile(File file, InputStream in) {
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[40960];
        int numRead = 0;
        int counter = 0;
        while ((numRead = in.read(buffer)) != -1) {
            counter += numRead;
            out.write(buffer, 0, numRead);
            out.flush();
        }
        out.flush();
        in.close();
        out.close();
    }

    public FileDelete(String fileName, boolean hasHeader) {
        this.fileName = fileName;
        RecordDeletor$class.$init$(this);
        this.sftpPattern = new StringOps(Predef$.MODULE$.augmentString("sftp://([a-zA-z\\.]*):([0-9a-zA-Z_/\\.\\-]*)")).r();
    }
}

