/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.com.bytecode.opencsv.CSVWriter;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.export.DwCACreator;
import au.org.ala.biocache.util.OptionParser;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;
import scala.util.parsing.json.JSON$;

public final class DwCACreator$
implements Tool {
    public static final DwCACreator$ MODULE$;
    private final Logger logger;
    private final List<String> defaultFields;
    private final Regex dataResourcePattern;

    static {
        new DwCACreator$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "create-dwc";
    }

    @Override
    public String desc() {
        return "Create Darwin Core Archive for a data resource";
    }

    public Logger logger() {
        return this.logger;
    }

    public List<String> defaultFields() {
        return this.defaultFields;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void main(String[] args) {
        ObjectRef resourceUid = new ObjectRef((Object)"");
        ObjectRef directory = new ObjectRef((Object)"");
        IntRef threads = new IntRef(4);
        IntRef pageSize = new IntRef(1000);
        BooleanRef addImagesToExisting = new BooleanRef(false);
        OptionParser parser = new OptionParser(resourceUid, directory, threads, pageSize, addImagesToExisting){
            {
                this.arg("data-resource-uid", "The UID of the data resource to load or 'all' to generate for all", (Function1<String, BoxedUnit>)new Serializable(this, resourceUid$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef resourceUid$1;

                    public final void apply(String v) {
                        this.resourceUid$1.elem = v;
                    }
                    {
                        this.resourceUid$1 = resourceUid$1;
                    }
                });
                this.arg("directory-to-dump", "Directory to place the created archives", (Function1<String, BoxedUnit>)new Serializable(this, directory$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef directory$1;

                    public final void apply(String v) {
                        this.directory$1.elem = v;
                    }
                    {
                        this.directory$1 = directory$1;
                    }
                });
                this.intOpt("t", "thread", new StringBuilder().append((Object)"The number of threads to use. Default is ").append((Object)BoxesRunTime.boxToInteger((int)threads$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.intOpt("ps", "pageSize", new StringBuilder().append((Object)"The pageSize to use. Default is ").append((Object)BoxesRunTime.boxToInteger((int)pageSize$1.elem)).toString(), (Function1<Object, BoxedUnit>)new Serializable(this, pageSize$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef pageSize$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.pageSize$1.elem = v;
                    }
                    {
                        this.pageSize$1 = pageSize$1;
                    }
                });
                this.booleanOpt("add-images-to-existing-only", "Add images to existing archives.", (Function1<Object, BoxedUnit>)new Serializable(this, addImagesToExisting$1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef addImagesToExisting$1;

                    public final void apply(boolean v) {
                        this.addImagesToExisting$1.elem = v;
                    }
                    {
                        this.addImagesToExisting$1 = addImagesToExisting$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            DwCACreator dwcc = new DwCACreator();
            if (addImagesToExisting.elem) {
                dwcc.addImageExportsToArchives((String)directory.elem);
            } else {
                try {
                    Map dataResource2OutputStreams = ((TraversableOnce)this.getDataResourceUids().map((Function1)new Serializable(directory, dwcc){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef directory$1;
                        private final DwCACreator dwcc$1;

                        public final Tuple2<String, Option<Tuple2<ZipOutputStream, CSVWriter>>> apply(String uid) {
                            return new Tuple2((Object)uid, this.dwcc$1.createOutputForCSV((String)this.directory$1.elem, uid));
                        }
                        {
                            this.directory$1 = directory$1;
                            this.dwcc$1 = dwcc$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                    Config$.MODULE$.persistenceManager().pageOverSelect("occ", (Function2<String, Map<String, String>, Object>)new Serializable(dataResource2OutputStreams){
                        public static final long serialVersionUID = 0L;
                        private final Map dataResource2OutputStreams$1;

                        /*
                         * Unable to fully structure code
                         */
                        public final boolean apply(String key, Map<String, String> map) {
                            var3_3 = DwCACreator$.MODULE$;
                            synchronized (var3_3) {
                                block9: {
                                    block10: {
                                        block12: {
                                            block11: {
                                                dr = (String)map.getOrElse((Object)"dataResourceUid", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                });
                                                deletedDate = (String)map.getOrElse((Object)"deletedDate", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                });
                                                v0 = dr;
                                                var6_6 = "";
                                                if (!(v0 == null ? var6_6 != null : v0.equals(var6_6) == false)) break block10;
                                                v1 = deletedDate;
                                                var7_7 = "";
                                                if (v1 != null ? v1.equals(var7_7) == false : var7_7 != null) break block10;
                                                dataResourceMap = this.dataResource2OutputStreams$1.get((Object)dr);
                                                if (!dataResourceMap.isEmpty() && !((Option)dataResourceMap.get()).isEmpty()) break block11;
                                                v2 = BoxedUnit.UNIT;
                                                break block9;
                                            }
                                            var10_9 = (Tuple2)((Option)dataResourceMap.get()).get();
                                            if (var10_9 == null) break block12;
                                            zop = (ZipOutputStream)var10_9._1();
                                            csv = (CSVWriter)var10_9._2();
                                            var9_13 = var13_12 = new Tuple2((Object)zop, (Object)csv);
                                            zop = (ZipOutputStream)var9_13._1();
                                            csv = (CSVWriter)var9_13._2();
                                            var16_16 = DwCACreator$.MODULE$;
                                            synchronized (var16_16) {
                                                eventDate = (String)map.getOrElse((Object)"eventDate_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                });
                                                v3 = eventDateEnd = (String)map.getOrElse((Object)"eventDateEnd_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                });
                                                var21_19 = "";
                                                if (!(v3 == null ? var21_19 != null : v3.equals(var21_19) == false)) ** GOTO lbl-1000
                                                v4 = eventDate;
                                                var22_20 = "";
                                                if (!(v4 == null ? var22_20 != null : v4.equals(var22_20) == false)) ** GOTO lbl-1000
                                                v5 = eventDate;
                                                var23_21 = eventDateEnd;
                                                if (!(v5 != null ? v5.equals(var23_21) == false : var23_21 != null)) lbl-1000:
                                                // 3 sources

                                                {
                                                    v6 = eventDate;
                                                } else {
                                                    v6 = new StringBuilder().append((Object)eventDate).append((Object)"/").append((Object)eventDateEnd).toString();
                                                }
                                                eventDate = v6;
                                                csv.writeNext((String[])((Object[])new String[]{DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"rowkey", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"catalogNumber", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"collectionCode", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"institutionCode", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"recordNumber", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"basisOfRecord_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"recordedBy", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"occurrenceStatus_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"individualCount", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"scientificName_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"taxonConceptID_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"taxonRank_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"kingdom_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"phylum_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"classs_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"order_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"family_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"genus_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"vernacularName_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"decimalLatitude_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"decimalLongitude_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"geodeticDatum_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"coordinateUncertaintyInMeters_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"maximumElevationInMeters", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"minimumElevationInmeters", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"minimumDepthInMeters", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"maximumDepthInMeters", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"country_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"stateProvince_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"locality", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"locationRemarks", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"year_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"month_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"day_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue(eventDate), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"eventID", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"identifiedBy", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"occurrenceRemarks", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                })), DwCACreator$.MODULE$.cleanValue((String)map.getOrElse((Object)"dataGeneralizations_p", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "";
                                                    }
                                                }))}));
                                                csv.flush();
                                                var17_23 = BoxedUnit.UNIT;
                                                // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4] lbl43 : MonitorExitStatement: MONITOREXIT : var16_16
                                                v2 = var17_23;
                                                break block9;
                                            }
                                        }
                                        throw new MatchError((Object)var10_9);
                                    }
                                    v2 = BoxedUnit.UNIT;
                                }
                                return true;
                                {
                                    catch (Throwable v7) {
                                        throw v7;
                                    }
                                }
                            }
                        }
                        {
                            this.dataResource2OutputStreams$1 = dataResource2OutputStreams$1;
                        }
                    }, threads.elem, pageSize.elem, (Seq<String>)this.defaultFields());
                    dataResource2OutputStreams.values().foreach((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final void apply(Option<Tuple2<ZipOutputStream, CSVWriter>> zopAndCsv) {
                            ((DeflaterOutputStream)((Tuple2)zopAndCsv.get())._1()).flush();
                            ((ZipOutputStream)((Tuple2)zopAndCsv.get())._1()).closeEntry();
                            ((ZipOutputStream)((Tuple2)zopAndCsv.get())._1()).close();
                        }
                    });
                    dwcc.addImageExportsToArchives((String)directory.elem);
                }
                catch (Exception exception) {
                    this.logger().error(exception.getMessage(), (Throwable)exception);
                    throw new RuntimeException(exception);
                }
            }
        }
        Config$.MODULE$.persistenceManager().shutdown();
    }

    public String cleanValue(String input) {
        return input == null ? "" : input.replaceAll("[\\t\\n\\r]", " ").trim();
    }

    public Regex dataResourcePattern() {
        return this.dataResourcePattern;
    }

    public Seq<String> getDataResourceUids() {
        String url = new StringBuilder().append((Object)Config$.MODULE$.biocacheServiceUrl()).append((Object)"/occurrences/search?q=*:*&facets=data_resource_uid&pageSize=0&flimit=-1").toString();
        String jsonString = Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString();
        Map json = (Map)JSON$.MODULE$.parseFull(jsonString).get();
        List results = (List)((MapLike)((List)json.get((Object)"facetResults").get()).head()).get((Object)"fieldResult").get();
        return (Seq)((TraversableLike)results.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Map<String, String> facet) {
                String fq = (String)facet.get((Object)"fq").get();
                return DwCACreator$.MODULE$.parseFq(fq);
            }
        }, List$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$2) {
                return x$2.equals("Unknown");
            }
        });
    }

    public String parseFq(String fq) {
        String dr;
        String string = fq;
        Option option = this.dataResourcePattern().unapplySeq((Object)string);
        String string2 = !option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0 ? (dr = (String)((LinearSeqOptimized)option.get()).apply(0)) : "Unknown";
        return string2;
    }

    private DwCACreator$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"DwCACreator");
        this.defaultFields = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowkey", "dataResourceUid", "catalogNumber", "collectionCode", "institutionCode", "scientificName_p", "recordedBy", "taxonConceptID_p", "taxonRank_p", "kingdom_p", "phylum_p", "classs_p", "order_p", "family_p", "genus_p", "decimalLatitude_p", "decimalLongitude_p", "coordinateUncertaintyInMeters_p", "maximumElevationInMeters", "minimumElevationInMeters", "minimumDepthInMeters", "maximumDepthInMeters", "geodeticDatum_p", "country_p", "stateProvince_p", "locality", "occurrenceStatus_p", "year_p", "month_p", "day_p", "eventDate_p", "eventDateEnd_p", "basisOfRecord_p", "identifiedBy", "occurrenceRemarks", "locationRemarks", "recordNumber", "vernacularName_p", "individualCount", "eventID", "dataGeneralizations_p"}));
        this.dataResourcePattern = new StringOps(Predef$.MODULE$.augmentString("(?:[\"]*)?(?:[a-z_]*_uid:\")([a-z0-9]*)(?:[\"]*)?")).r();
    }
}

