/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.export.ExportFacet$;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import scala.Array$;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ExportFacet$
implements Tool {
    public static final ExportFacet$ MODULE$;
    private String facetField;
    private String facetQuery;
    private String facetOutputFile;
    private boolean lastDay;
    private boolean lastWeek;
    private boolean lastMonth;
    private boolean includeCounts;
    private String indexDateField;
    private boolean closeIndex;
    private String[] fieldsToExport;
    private final OptionParser parser;

    static {
        new ExportFacet$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "export-facet";
    }

    @Override
    public String desc() {
        return "Exports a facet to file. From SOLR";
    }

    public String facetField() {
        return this.facetField;
    }

    public void facetField_$eq(String x$1) {
        this.facetField = x$1;
    }

    public String facetQuery() {
        return this.facetQuery;
    }

    public void facetQuery_$eq(String x$1) {
        this.facetQuery = x$1;
    }

    public String facetOutputFile() {
        return this.facetOutputFile;
    }

    public void facetOutputFile_$eq(String x$1) {
        this.facetOutputFile = x$1;
    }

    public boolean lastDay() {
        return this.lastDay;
    }

    public void lastDay_$eq(boolean x$1) {
        this.lastDay = x$1;
    }

    public boolean lastWeek() {
        return this.lastWeek;
    }

    public void lastWeek_$eq(boolean x$1) {
        this.lastWeek = x$1;
    }

    public boolean lastMonth() {
        return this.lastMonth;
    }

    public void lastMonth_$eq(boolean x$1) {
        this.lastMonth = x$1;
    }

    public boolean includeCounts() {
        return this.includeCounts;
    }

    public void includeCounts_$eq(boolean x$1) {
        this.includeCounts = x$1;
    }

    public String indexDateField() {
        return this.indexDateField;
    }

    public void indexDateField_$eq(String x$1) {
        this.indexDateField = x$1;
    }

    public boolean closeIndex() {
        return this.closeIndex;
    }

    public void closeIndex_$eq(boolean x$1) {
        this.closeIndex = x$1;
    }

    public String[] fieldsToExport() {
        return this.fieldsToExport;
    }

    public void fieldsToExport_$eq(String[] x$1) {
        this.fieldsToExport = x$1;
    }

    public OptionParser parser() {
        return this.parser;
    }

    @Override
    public void main(String[] args) {
        if (this.parser().parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            SimpleDateFormat sfd = new SimpleDateFormat("yyyy-MM-dd");
            String facetFilterQuery = "";
            if (this.lastDay()) {
                facetFilterQuery = new StringBuilder().append((Object)this.indexDateField()).append((Object)":[").append((Object)sfd.format(DateUtils.addDays((Date)new Date(), (int)-1))).append((Object)"T00:00:00Z TO *]").toString();
            } else if (this.lastWeek()) {
                facetFilterQuery = new StringBuilder().append((Object)this.indexDateField()).append((Object)":[").append((Object)sfd.format(DateUtils.addWeeks((Date)new Date(), (int)-1))).append((Object)"T00:00:00Z TO *]").toString();
            } else if (this.lastMonth()) {
                facetFilterQuery = new StringBuilder().append((Object)this.indexDateField()).append((Object)":[").append((Object)sfd.format(DateUtils.addMonths((Date)new Date(), (int)-1))).append((Object)"T00:00:00Z TO *]").toString();
            }
            FileWriter facetWriter = new FileWriter(new File(this.facetOutputFile()));
            Config$.MODULE$.indexDAO().pageOverFacet((Function2<String, Object, Object>)new Serializable(facetWriter){
                public static final long serialVersionUID = 0L;
                private final FileWriter facetWriter$1;

                public final boolean apply(String label, int count) {
                    this.facetWriter$1.write(label);
                    if (ExportFacet$.MODULE$.includeCounts()) {
                        this.facetWriter$1.write(new StringBuilder().append((Object)"\t").append((Object)BoxesRunTime.boxToInteger((int)count)).toString());
                    }
                    this.facetWriter$1.write("\n");
                    this.facetWriter$1.flush();
                    return true;
                }
                {
                    this.facetWriter$1 = facetWriter$1;
                }
            }, this.facetField(), this.facetQuery(), (String[])((Object[])new String[]{facetFilterQuery}));
            facetWriter.flush();
            facetWriter.close();
            if (this.closeIndex()) {
                Config$.MODULE$.indexDAO().shutdown();
            }
        }
    }

    private ExportFacet$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.facetField = "species_guid";
        this.facetQuery = "*:*";
        this.facetOutputFile = new StringBuilder().append((Object)Config$.MODULE$.tmpWorkDir()).append((Object)"/facet-output-").append((Object)this.facetField()).append((Object)".txt").toString();
        this.lastDay = false;
        this.lastWeek = false;
        this.lastMonth = false;
        this.includeCounts = false;
        this.indexDateField = "first_loaded_date";
        this.closeIndex = true;
        this.fieldsToExport = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.parser = new anon.1();
    }
}

