/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.export;

import au.org.ala.biocache.export.ExportAllRecordFacetFilter$;
import au.org.ala.biocache.export.ExportByFacetQuery$;
import au.org.ala.biocache.export.ExportFacet$;
import au.org.ala.biocache.tool.DuplicationDetection$;
import au.org.ala.biocache.util.CountAwareFacetConsumer;
import au.org.ala.biocache.util.FileHelper$;
import au.org.ala.biocache.util.OptionParser;
import au.org.ala.biocache.util.StringConsumer;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.io.FileUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.StringAdd$;

public final class ExportAllRecordFacetFilter$ {
    public static final ExportAllRecordFacetFilter$ MODULE$;

    static {
        new ExportAllRecordFacetFilter$();
    }

    public void main(String[] args) {
        ObjectRef exportDirectory = new ObjectRef((Object)"/data/offline/exports");
        ObjectRef facet = new ObjectRef((Object)"");
        IntRef threads = new IntRef(4);
        ObjectRef filter = new ObjectRef((Object)None$.MODULE$);
        String[] fieldsToExport = (String[])((Object[])new String[]{"row_key", "id", "species_guid", "subspecies_guid", "year", "month", "occurrence_date", "point-1", "point-0.1", "point-0.01", "point-0.001", "point-0.0001", "lat_long", "raw_taxon_name", "collectors", "duplicate_status", "duplicate_record", "latitude", "longitude", "el882", "el889", "el887", "el865", "el894"});
        OptionParser parser = new OptionParser(exportDirectory, facet, threads, filter){
            {
                this.arg("<output directory>", "the output directory for the exports", (Function1<String, BoxedUnit>)new Serializable(this, exportDirectory$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef exportDirectory$1;

                    public final void apply(String v) {
                        this.exportDirectory$1.elem = v;
                    }
                    {
                        this.exportDirectory$1 = exportDirectory$1;
                    }
                });
                this.arg("<facet>", "The facet to base the download", (Function1<String, BoxedUnit>)new Serializable(this, facet$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef facet$1;

                    public final void apply(String v) {
                        this.facet$1.elem = v;
                    }
                    {
                        this.facet$1 = facet$1;
                    }
                });
                this.intOpt("t", "threads", "the number of threads/files to have for the exports", (Function1<Object, BoxedUnit>)new Serializable(this, threads$1){
                    public static final long serialVersionUID = 0L;
                    private final IntRef threads$1;

                    public final void apply(int v) {
                        this.apply$mcVI$sp(v);
                    }

                    public void apply$mcVI$sp(int v) {
                        this.threads$1.elem = v;
                    }
                    {
                        this.threads$1 = threads$1;
                    }
                });
                this.opt("f", "filter", "optional filter to apply to the list", (Function1<String, BoxedUnit>)new Serializable(this, filter$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef filter$1;

                    public final void apply(String v) {
                        this.filter$1.elem = new Some((Object)v);
                    }
                    {
                        this.filter$1 = filter$1;
                    }
                });
            }
        };
        if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
            String filename = new StringBuilder().append((Object)((String)exportDirectory.elem)).append((Object)File.separator).append((Object)"species-guids.txt").toString();
            FileUtils.forceMkdir((File)new File((String)exportDirectory.elem));
            String[] args2 = ((Option)filter.elem).isDefined() ? (String[])((Object[])new String[]{(String)facet.elem, filename, "-fq", (String)((Option)filter.elem).get(), "--open", "-c", "true"}) : (String[])((Object[])new String[]{(String)facet.elem, filename, "--open", "-c", "true"});
            Predef$.MODULE$.println((Object)StringAdd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)new Date()), " Exporting the facets to be ued in the download"));
            ExportFacet$.MODULE$.main(args2);
            ArrayBlockingQueue queue = new ArrayBlockingQueue(100);
            IntRef ids = new IntRef(0);
            Thread[] pool = (Thread[])Array$.MODULE$.fill(threads.elem, (Function0)new Serializable(exportDirectory, fieldsToExport, queue, ids){
                public static final long serialVersionUID = 0L;
                private final ObjectRef exportDirectory$1;
                public final String[] fieldsToExport$1;
                private final ArrayBlockingQueue queue$1;
                private final IntRef ids$1;

                public final CountAwareFacetConsumer apply() {
                    File file = new File(new StringBuilder().append((Object)((String)this.exportDirectory$1.elem)).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)this.ids$1.elem)).append((Object)File.separator).append((Object)"species.out").toString());
                    File subspeciesfile = new File(new StringBuilder().append((Object)((String)this.exportDirectory$1.elem)).append((Object)File.separator).append((Object)BoxesRunTime.boxToInteger((int)this.ids$1.elem)).append((Object)File.separator).append((Object)"subspecies.out").toString());
                    FileUtils.forceMkdir((File)file.getParentFile());
                    FileWriter fileWriter = new FileWriter(file);
                    CountAwareFacetConsumer p = new CountAwareFacetConsumer(this.queue$1, this.ids$1.elem, (Function1<String[], BoxedUnit>)new Serializable(this, subspeciesfile, fileWriter){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.5 $outer;
                        private final File subspeciesfile$1;
                        private final FileWriter fileWriter$1;

                        public final void apply(String[] lsids) {
                            String query = Predef$.MODULE$.refArrayOps((Object[])lsids).mkString("species_guid:\"", "\" OR species_guid:\"", "\"");
                            DuplicationDetection$.MODULE$.logger().info(new StringBuilder().append((Object)"Starting to download the occurrences for ").append((Object)Predef$.MODULE$.refArrayOps((Object[])lsids).mkString(",")).toString());
                            ExportByFacetQuery$.MODULE$.downloadSingleTaxonByStream(query, null, this.$outer.fieldsToExport$1, "species_guid", (String[])((Object[])new String[]{"lat_long:[* TO *]"}), (String[])((Object[])new String[]{"species_guid", "subspecies_guid", "row_key"}), this.fileWriter$1, (Option<FileWriter>)new Some((Object)new FileWriter(this.subspeciesfile$1)), (Option<String[]>)new Some((Object)new String[]{"duplicate_record"}));
                            this.fileWriter$1.flush();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.subspeciesfile$1 = subspeciesfile$1;
                            this.fileWriter$1 = fileWriter$1;
                        }
                    }, 10000, 2);
                    ++this.ids$1.elem;
                    p.start();
                    return p;
                }
                {
                    this.exportDirectory$1 = exportDirectory$1;
                    this.fieldsToExport$1 = fieldsToExport$1;
                    this.queue$1 = queue$1;
                    this.ids$1 = ids$1;
                }
            }, ClassTag$.MODULE$.apply(Thread.class));
            FileHelper$.MODULE$.file2helper(new File(filename)).foreachLine((Function1<String, BoxedUnit>)new Serializable(queue){
                public static final long serialVersionUID = 0L;
                private final ArrayBlockingQueue queue$1;

                public final void apply(String line) {
                    this.queue$1.put(line.trim());
                }
                {
                    this.queue$1 = queue$1;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Thread t) {
                    if (t instanceof StringConsumer) {
                        ((StringConsumer)t).shouldStop_$eq(true);
                    }
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])pool).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Thread x$1) {
                    x$1.join();
                }
            });
        }
    }

    private ExportAllRecordFacetFilter$() {
        MODULE$ = this;
    }
}

