/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.util;

import au.org.ala.biocache.model.Classification;
import au.org.ala.names.model.LinnaeanRankClassification;
import au.org.ala.names.model.NameSearchResult;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class BiocacheConversions$ {
    public static final BiocacheConversions$ MODULE$;
    private final Logger logger;

    static {
        new BiocacheConversions$();
    }

    public Logger logger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    public Classification asClassification(NameSearchResult nsr) {
        void var2_2;
        Classification cl = new Classification();
        LinnaeanRankClassification rankClassification = nsr.getRankClassification();
        cl.kingdom_$eq(rankClassification.getKingdom());
        cl.kingdomID_$eq(rankClassification.getKid());
        cl.phylum_$eq(rankClassification.getPhylum());
        cl.phylumID_$eq(rankClassification.getPid());
        cl.classs_$eq(rankClassification.getKlass());
        cl.classID_$eq(rankClassification.getCid());
        cl.order_$eq(rankClassification.getOrder());
        cl.orderID_$eq(rankClassification.getOid());
        cl.family_$eq(rankClassification.getFamily());
        cl.familyID_$eq(rankClassification.getFid());
        cl.genus_$eq(rankClassification.getGenus());
        cl.genusID_$eq(rankClassification.getGid());
        cl.species_$eq(rankClassification.getSpecies());
        cl.speciesID_$eq(rankClassification.getSid());
        cl.specificEpithet_$eq(rankClassification.getSpecificEpithet());
        cl.scientificName_$eq(rankClassification.getScientificName());
        cl.subspecies_$eq(rankClassification.getSubspecies());
        if (cl.subspecies() != null && new StringOps(Predef$.MODULE$.augmentString(cl.subspecies())).size() > 0) {
            cl.subspeciesID_$eq(nsr.getLsid());
        }
        cl.taxonConceptID_$eq(nsr.getLsid());
        cl.left_$eq(nsr.getLeft());
        cl.right_$eq(nsr.getRight());
        if (nsr.getRank() == null) {
            this.logger().debug(new StringBuilder().append((Object)nsr.getLsid()).append((Object)" doesn't have a rank ").append((Object)rankClassification.getScientificName()).toString());
        } else {
            cl.taxonRank_$eq(nsr.getRank().getRank());
            cl.taxonRankID_$eq(nsr.getRank().getId().toString());
        }
        cl.nameMatchMetric_$eq(nsr.getMatchType().toString());
        return var2_2;
    }

    public String dateToString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone(ZoneId.of("UTC")));
        return format.format(date);
    }

    private BiocacheConversions$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"BiocacheConversions");
    }
}

