/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.cas.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatchingUtils {
    private static final Logger logger = Logger.getLogger(PatternMatchingUtils.class);

    public static List<Pattern> getPatternList(String context, String regexPatterns) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        if (regexPatterns != null && !regexPatterns.equals("")) {
            for (String regex : regexPatterns.split(",")) {
                patternList.add(Pattern.compile(context + regex.trim(), 2));
            }
        }
        return patternList;
    }

    public static boolean matches(String str, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(str);
            logger.trace((Object)("Matching string '" + str + "' against Pattern '" + pattern + "'"));
            if (matcher.matches()) {
                logger.trace((Object)"Matches!");
                return true;
            }
            logger.trace((Object)"No match");
        }
        return false;
    }
}

