/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.cas.util;

import au.org.ala.cas.util.AuthenticationCookieUtils;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.CommonUtils;

public class AuthenticationUtils {
    private static final Logger logger = Logger.getLogger(AuthenticationUtils.class);
    private static final String ATTR_USER_ID = "userid";
    private static final String ATTR_EMAIL_ADDRESS = "email";
    private static final String ATTR_FIRST_NAME = "firstname";
    private static final String ATTR_LAST_NAME = "lastname";
    private static final String ATTR_ROLES = "authority";

    public static String getUserId(HttpServletRequest request) {
        return AuthenticationUtils.getPrincipalAttribute(request, ATTR_USER_ID);
    }

    public static String getEmailAddress(HttpServletRequest request) {
        String email = AuthenticationUtils.getPrincipalAttribute(request, ATTR_EMAIL_ADDRESS);
        if (email == null) {
            logger.debug((Object)String.format("Unable to retrieve email from User Principal. Looking in ALA cookie.", new Object[0]));
            email = AuthenticationCookieUtils.getUserName(request);
        }
        return email;
    }

    public static String getDisplayName(HttpServletRequest request) {
        String firstname = AuthenticationUtils.getPrincipalAttribute(request, ATTR_FIRST_NAME);
        String lastname = AuthenticationUtils.getPrincipalAttribute(request, ATTR_LAST_NAME);
        String displayName = null;
        if (CommonUtils.isNotBlank((String)firstname) && CommonUtils.isNotBlank((String)lastname)) {
            displayName = String.format("%s %s", firstname, lastname);
        } else if (CommonUtils.isNotBlank((String)firstname) || CommonUtils.isNotBlank((String)lastname)) {
            displayName = String.format("%s", CommonUtils.isNotBlank((String)firstname) ? firstname : lastname);
        }
        return displayName;
    }

    public static boolean isUserInRole(HttpServletRequest request, String role) {
        if (CommonUtils.isBlank((String)role)) {
            return false;
        }
        String roles = AuthenticationUtils.getPrincipalAttribute(request, ATTR_ROLES);
        if (CommonUtils.isNotBlank((String)roles)) {
            for (String roleValue : roles.split(",")) {
                if (!role.equalsIgnoreCase(roleValue.trim())) continue;
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    private static String getPrincipalAttribute(HttpServletRequest request, String attributeKey) {
        if (request == null) {
            logger.debug((Object)String.format("Request is null! (Looking for attribute %s)", attributeKey));
            return null;
        }
        Principal principal = request.getUserPrincipal();
        if (principal != null && principal instanceof AttributePrincipal) {
            AttributePrincipal attrPrincipal = (AttributePrincipal)principal;
            Object attrValue = attrPrincipal.getAttributes().get(attributeKey);
            logger.debug((Object)String.format("getPrincipalAttribute(%s) = %s", attributeKey, attrValue == null ? "null" : attrValue.toString()));
            return attrValue == null ? null : attrValue.toString();
        }
        return null;
    }
}

