/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.cas.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class AuthenticationCookieUtils {
    private static final Logger logger = Logger.getLogger(AuthenticationCookieUtils.class);
    public static final String ALA_AUTH_COOKIE = "ALA-Auth";

    public static boolean isUserLoggedIn(HttpServletRequest request) {
        return AuthenticationCookieUtils.cookieExists(request, ALA_AUTH_COOKIE);
    }

    public static String getUserName(HttpServletRequest request) {
        return AuthenticationCookieUtils.getCookieValue(request, ALA_AUTH_COOKIE);
    }

    public static boolean cookieExists(HttpServletRequest request, String name) {
        return AuthenticationCookieUtils.getCookieValue(request, name) != null;
    }

    public static String getCookieValue(HttpServletRequest request, String name) {
        String value = null;
        Cookie cookie = AuthenticationCookieUtils.getCookie(request, name);
        if (cookie != null) {
            value = cookie.getValue();
        }
        return value;
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        if (request == null) {
            logger.warn((Object)"getCookie(): Request is null!");
            return null;
        }
        Cookie cookie = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals(name)) continue;
                cookie = c;
                break;
            }
        }
        if (cookie == null) {
            logger.debug((Object)("Cookie " + name + " not found"));
        } else {
            logger.debug((Object)("Cookie " + name + " found"));
        }
        return cookie;
    }
}

