/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.cas.client;

import au.org.ala.cas.client.UriFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;

public class WebServiceAuthenticationHelper {
    private static final Logger logger = Logger.getLogger(UriFilter.class);
    private static final String CAS_CONTEXT = "/cas/v1/tickets/";
    private final String casServer;
    private final String ticketGrantingTicket;

    public WebServiceAuthenticationHelper(String casServer, String userName, String password) {
        this.casServer = casServer;
        this.ticketGrantingTicket = this.getTicketGrantingTicket(casServer, userName, password);
    }

    public String invoke(String serviceUrl) {
        String serviceTicket = this.getServiceTicket(this.casServer, this.ticketGrantingTicket, serviceUrl);
        if (serviceTicket != null) {
            return this.getServiceResponse(serviceUrl, serviceTicket);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTicketGrantingTicket(String server, String username, String password) {
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(server + CAS_CONTEXT);
        post.setRequestBody(new NameValuePair[]{new NameValuePair("username", username), new NameValuePair("password", password)});
        try {
            client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            switch (post.getStatusCode()) {
                case 201: {
                    Matcher matcher = Pattern.compile(".*action=\".*/(.*?)\".*").matcher(response);
                    if (matcher.matches()) {
                        String string = matcher.group(1);
                        return string;
                    }
                    logger.warn((Object)"Successful ticket granting request, but no ticket found!");
                    logger.info((Object)("Response (1k): " + this.getMaxString(response)));
                    return null;
                }
                default: {
                    logger.warn((Object)("Invalid response code (" + post.getStatusCode() + ") from CAS server!"));
                    logger.info((Object)("Response (1k): " + this.getMaxString(response)));
                    return null;
                }
            }
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        finally {
            post.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceTicket(String server, String ticketGrantingTicket, String service) {
        if (ticketGrantingTicket == null) {
            return null;
        }
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(server + CAS_CONTEXT + ticketGrantingTicket);
        post.setRequestBody(new NameValuePair[]{new NameValuePair("service", service)});
        try {
            client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            switch (post.getStatusCode()) {
                case 200: {
                    String string = response;
                    return string;
                }
            }
            logger.warn((Object)("Invalid response code (" + post.getStatusCode() + ") from CAS server!"));
            logger.info((Object)("Response (1k): " + this.getMaxString(response)));
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            post.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceResponse(String url, String serviceTicket) {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(url + "?ticket=" + serviceTicket);
        try {
            client.executeMethod((HttpMethod)get);
            InputStream response = get.getResponseBodyAsStream();
            switch (get.getStatusCode()) {
                case 200: {
                    String string = this.getStringFromInputStream(response);
                    return string;
                }
            }
            logger.warn((Object)("Invalid response code (" + get.getStatusCode() + ") from web service!"));
            logger.info((Object)("Response (1k): " + this.getMaxString(this.getStringFromInputStream(response))));
        }
        catch (IOException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStringFromInputStream(InputStream is) throws IOException {
        if (is != null) {
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            finally {
                is.close();
            }
            return sb.toString();
        }
        return "";
    }

    private String getMaxString(String string) {
        return string.substring(0, Math.min(1024, string.length()));
    }
}

