/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.cas.client;

import au.org.ala.cas.client.AlaFilterConfig;
import au.org.ala.cas.util.AuthenticationCookieUtils;
import au.org.ala.cas.util.PatternMatchingUtils;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jasig.cas.client.authentication.AuthenticationFilter;

public class UriFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(UriFilter.class);
    private static final String URI_FILTER_PATTERN = "uriFilterPattern";
    private static final String URI_EXCLUSION_FILTER_PATTERN = "uriExclusionFilterPattern";
    private static final String AUTHENTICATE_ONLY_IF_LOGGED_IN_FILTER_PATTERN = "authenticateOnlyIfLoggedInFilterPattern";
    private Filter filter;
    private String contextPath;
    private List<Pattern> uriInclusionPatterns;
    private List<Pattern> authOnlyIfLoggedInPatterns;
    private List<Pattern> uriExclusionPatterns;
    private boolean disabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        String disableCAS = (filterConfig = new AlaFilterConfig(filterConfig)).getInitParameter("disableCAS");
        if (disableCAS != null && disableCAS.equals("true")) {
            logger.info((Object)"CAS is disabled.");
            this.disabled = true;
        } else {
            this.contextPath = filterConfig.getServletContext().getInitParameter("contextPath");
            if (this.contextPath == null) {
                this.contextPath = "";
            } else {
                logger.debug((Object)("Context path = '" + this.contextPath + "'"));
            }
            String includedUrlPattern = filterConfig.getServletContext().getInitParameter(URI_FILTER_PATTERN);
            if (includedUrlPattern == null) {
                includedUrlPattern = "";
            }
            logger.debug((Object)("Included URI Pattern = '" + includedUrlPattern + "'"));
            this.uriInclusionPatterns = PatternMatchingUtils.getPatternList(this.contextPath, includedUrlPattern);
            String excludedUrlPattern = filterConfig.getServletContext().getInitParameter(URI_EXCLUSION_FILTER_PATTERN);
            if (excludedUrlPattern == null) {
                excludedUrlPattern = "";
            }
            logger.debug((Object)("Excluded URI Pattern = '" + excludedUrlPattern + "'"));
            this.uriExclusionPatterns = PatternMatchingUtils.getPatternList(this.contextPath, excludedUrlPattern);
            String authOnlyIfLoggedInPattern = filterConfig.getServletContext().getInitParameter(AUTHENTICATE_ONLY_IF_LOGGED_IN_FILTER_PATTERN);
            if (authOnlyIfLoggedInPattern == null) {
                authOnlyIfLoggedInPattern = "";
            }
            logger.debug((Object)("Authenticate Only if Logged in Pattern = '" + authOnlyIfLoggedInPattern + "'"));
            this.authOnlyIfLoggedInPatterns = PatternMatchingUtils.getPatternList(this.contextPath, authOnlyIfLoggedInPattern);
            String className = filterConfig.getInitParameter("filterClass");
            try {
                Class<?> c = Class.forName(className);
                this.filter = (Filter)c.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.filter.init(filterConfig);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.disabled) {
            String requestUri = ((HttpServletRequest)request).getRequestURI();
            if (this.filter instanceof AuthenticationFilter) {
                logger.debug((Object)("Request Uri = '" + requestUri + "'"));
            }
            if (PatternMatchingUtils.matches(requestUri, this.uriExclusionPatterns)) {
                if (this.filter instanceof AuthenticationFilter) {
                    logger.debug((Object)"Ignoring URI because it matches uriExclusionFilterPattern");
                } else {
                    logger.debug((Object)("No action taken as matches uriExclusionPatterns for " + requestUri));
                }
                chain.doFilter(request, response);
            } else if (PatternMatchingUtils.matches(requestUri, this.uriInclusionPatterns)) {
                if (this.filter instanceof AuthenticationFilter) {
                    logger.debug((Object)("Forwarding URI '" + requestUri + "' to CAS authentication filters because it matches " + URI_FILTER_PATTERN));
                } else {
                    logger.debug((Object)("No action taken - no matching pattern found in uriInclusionPatterns for " + requestUri));
                }
                this.filter.doFilter(request, response, chain);
            } else if (PatternMatchingUtils.matches(requestUri, this.authOnlyIfLoggedInPatterns) && AuthenticationCookieUtils.isUserLoggedIn((HttpServletRequest)request)) {
                if (this.filter instanceof AuthenticationFilter) {
                    logger.debug((Object)("Forwarding URI '" + requestUri + "' to CAS authentication filters because it matches " + AUTHENTICATE_ONLY_IF_LOGGED_IN_FILTER_PATTERN + " and ALA-Auth cookie exists"));
                } else {
                    logger.debug((Object)("No action taken - no matching pattern found in authOnlyIfLoggedInPatterns for " + requestUri));
                }
                this.filter.doFilter(request, response, chain);
            } else {
                logger.debug((Object)("No action taken - no matching pattern found for " + requestUri));
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
        this.filter.destroy();
    }
}

