/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.cas.client;

import au.org.ala.cas.client.AlaFilterConfig;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.util.AbstractConfigurationFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public class AlaHttpServletRequestWrapperFilter
extends AbstractConfigurationFilter {
    private String roleAttribute;
    private boolean ignoreCase;

    public void init(FilterConfig filterConfig) throws ServletException {
        filterConfig = new AlaFilterConfig(filterConfig);
        this.roleAttribute = this.getPropertyFromInitParams(filterConfig, "roleAttribute", "authority");
        this.ignoreCase = Boolean.parseBoolean(this.getPropertyFromInitParams(filterConfig, "ignoreCase", "true"));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AttributePrincipal principal = this.retrievePrincipalFromSessionOrRequest(request);
        chain.doFilter((ServletRequest)new AlaHttpServletRequestWrapper((HttpServletRequest)request, principal), response);
    }

    private AttributePrincipal retrievePrincipalFromSessionOrRequest(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession(false);
        Assertion assertion = (Assertion)(session == null ? request.getAttribute("_const_cas_assertion_") : session.getAttribute("_const_cas_assertion_"));
        return assertion == null ? null : assertion.getPrincipal();
    }

    public void destroy() {
    }

    class AlaHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final AttributePrincipal principal;

        AlaHttpServletRequestWrapper(HttpServletRequest request, AttributePrincipal principal) {
            super(request);
            this.principal = principal;
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public String getRemoteUser() {
            return this.principal != null ? this.principal.getName() : null;
        }

        public boolean isUserInRole(String role) {
            block7: {
                Object value;
                block5: {
                    block6: {
                        if (CommonUtils.isBlank((String)role)) {
                            AlaHttpServletRequestWrapperFilter.this.log.debug((Object)"No valid role provided.  Returning false.");
                            return false;
                        }
                        if (this.principal == null) {
                            AlaHttpServletRequestWrapperFilter.this.log.debug((Object)"No Principal in Request.  Returning false.");
                            return false;
                        }
                        if (CommonUtils.isBlank((String)AlaHttpServletRequestWrapperFilter.this.roleAttribute)) {
                            AlaHttpServletRequestWrapperFilter.this.log.debug((Object)"No Role Attribute Configured. Returning false.");
                            return false;
                        }
                        value = this.principal.getAttributes().get(AlaHttpServletRequestWrapperFilter.this.roleAttribute);
                        if (!(value instanceof String)) break block5;
                        String roles = (String)value;
                        if (roles == null || roles.equals("")) break block6;
                        for (String roleValue : roles.split(",")) {
                            if (!this.rolesEqual(role, roleValue.trim())) continue;
                            AlaHttpServletRequestWrapperFilter.this.log.debug((Object)("User [" + this.getRemoteUser() + "] is in role [" + role + "]: " + true));
                            return true;
                        }
                        break block7;
                    }
                    AlaHttpServletRequestWrapperFilter.this.log.debug((Object)"No role values in attributes. Returning false.");
                    return false;
                }
                if (!(value instanceof Collection)) break block7;
                Iterator iter = ((Collection)value).iterator();
                while (iter.hasNext()) {
                    if (!this.rolesEqual(role, iter.next())) continue;
                    AlaHttpServletRequestWrapperFilter.this.log.debug((Object)("User [" + this.getRemoteUser() + "] is in role [" + role + "]: " + true));
                    return true;
                }
            }
            return false;
        }

        private boolean rolesEqual(String given, Object candidate) {
            return AlaHttpServletRequestWrapperFilter.this.ignoreCase ? given.equalsIgnoreCase(candidate.toString()) : given.equals(candidate);
        }
    }
}

