/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.cas.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class AlaFilterConfig
implements FilterConfig {
    private static final Logger logger = Logger.getLogger(AlaFilterConfig.class);
    private FilterConfig embeddedFilterConfig;
    private ServletContext embeddedServletContext;
    private Properties casProperties;
    private List<String> whitelist;

    public AlaFilterConfig(FilterConfig config) {
        this.embeddedFilterConfig = config;
        this.loadProperties();
        this.embeddedServletContext = new AlaServletContext(config.getServletContext(), this.casProperties);
    }

    private void loadProperties() {
        block7: {
            try {
                InitialContext ctx = new InitialContext();
                String filename = (String)ctx.lookup("java:comp/env/configPropFile");
                this.casProperties = new Properties();
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(new File(filename)));
                    if (p.containsKey("casProperties")) {
                        this.whitelist = Arrays.asList(p.getProperty("casProperties").split(","));
                        for (String item : this.whitelist) {
                            String value = p.getProperty(item);
                            if (value == null) continue;
                            this.casProperties.put(item, p.getProperty(item));
                        }
                        break block7;
                    }
                    this.casProperties = p;
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to load config properties in " + filename), (Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.casProperties == null) {
            this.casProperties = new Properties();
        }
        logger.info((Object)("The configProperties " + this.casProperties));
    }

    public String getFilterName() {
        return this.embeddedFilterConfig.getFilterName();
    }

    public ServletContext getServletContext() {
        return this.embeddedServletContext;
    }

    public String getInitParameter(String name) {
        logger.debug((Object)("Extracting property from the ala filter " + name + " " + this.casProperties.getProperty(name)));
        return this.casProperties.getProperty(name, this.embeddedFilterConfig.getInitParameter(name));
    }

    public Enumeration getInitParameterNames() {
        return new MultiSourceEnumeration(new Enumeration[]{this.casProperties.keys(), this.embeddedFilterConfig.getInitParameterNames()});
    }

    public class MultiSourceEnumeration
    implements Enumeration {
        Enumeration[] sources;

        MultiSourceEnumeration(Enumeration[] sources) {
            this.sources = sources;
        }

        public boolean hasMoreElements() {
            for (Enumeration source : this.sources) {
                if (!source.hasMoreElements()) continue;
                return true;
            }
            return false;
        }

        public Object nextElement() {
            for (Enumeration source : this.sources) {
                if (!source.hasMoreElements()) continue;
                return source.nextElement();
            }
            return null;
        }
    }

    private class AlaServletContext
    implements ServletContext {
        private ServletContext embeddedContext;
        private Properties casProperties;

        AlaServletContext(ServletContext context, Properties properties) {
            this.embeddedContext = context;
            this.casProperties = properties;
        }

        public ServletContext getContext(String uripath) {
            return this.embeddedContext.getContext(uripath);
        }

        public int getMajorVersion() {
            return this.embeddedContext.getMajorVersion();
        }

        public int getMinorVersion() {
            return this.embeddedContext.getMinorVersion();
        }

        public String getMimeType(String file) {
            return this.embeddedContext.getMimeType(file);
        }

        public Set getResourcePaths(String path) {
            return this.embeddedContext.getResourcePaths(path);
        }

        public URL getResource(String path) throws MalformedURLException {
            return this.embeddedContext.getResource(path);
        }

        public InputStream getResourceAsStream(String path) {
            return this.embeddedContext.getResourceAsStream(path);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.embeddedContext.getRequestDispatcher(path);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return this.embeddedContext.getNamedDispatcher(name);
        }

        public Servlet getServlet(String name) throws ServletException {
            return this.embeddedContext.getServlet(name);
        }

        public Enumeration getServlets() {
            return this.embeddedContext.getServlets();
        }

        public Enumeration getServletNames() {
            return this.embeddedContext.getServletNames();
        }

        public void log(String msg) {
            this.embeddedContext.log(msg);
        }

        public void log(Exception exception, String msg) {
            this.embeddedContext.log(exception, msg);
        }

        public void log(String message, Throwable throwable) {
            this.embeddedContext.log(message, throwable);
        }

        public String getRealPath(String path) {
            return this.embeddedContext.getRealPath(path);
        }

        public String getServerInfo() {
            return this.embeddedContext.getServerInfo();
        }

        public String getInitParameter(String name) {
            logger.debug((Object)("Extracting property from the ala context " + name + " " + this.casProperties.getProperty(name)));
            return this.casProperties.getProperty(name, this.embeddedContext.getInitParameter(name));
        }

        public Enumeration getInitParameterNames() {
            return new MultiSourceEnumeration(new Enumeration[]{this.casProperties.keys(), this.embeddedContext.getInitParameterNames()});
        }

        public Object getAttribute(String name) {
            return this.embeddedContext.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return this.embeddedContext.getAttributeNames();
        }

        public void setAttribute(String name, Object object) {
            this.embeddedContext.setAttribute(name, object);
        }

        public void removeAttribute(String name) {
            this.embeddedContext.removeAttribute(name);
        }

        public String getServletContextName() {
            return this.embeddedContext.getServletContextName();
        }
    }
}

